<?php
/**
 * Class that operate on table 'clientproductreview'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2025-06-12 00:37
 */
class ClientproductreviewMySqlDAO implements ClientproductreviewDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return ClientproductreviewMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM clientproductreview WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM clientproductreview';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM clientproductreview ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param clientproductreview primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM clientproductreview WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param ClientproductreviewMySql clientproductreview
 	 */
	public function insert($clientproductreview){
		$sql = 'INSERT INTO clientproductreview (clientid, productid, rating, review, sysDate) VALUES (?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($clientproductreview->clientid);
		$sqlQuery->setNumber($clientproductreview->productid);
		$sqlQuery->setNumber($clientproductreview->rating);
		$sqlQuery->setString2($clientproductreview->review);
		$sqlQuery->set($clientproductreview->sysDate);

		$id = $this->executeInsert($sqlQuery);	
		$clientproductreview->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param ClientproductreviewMySql clientproductreview
 	 */
	public function update($clientproductreview){
		$sql = 'UPDATE clientproductreview SET clientid = ?, productid = ?, rating = ?, review = ?, sysDate = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($clientproductreview->clientid);
		$sqlQuery->setNumber($clientproductreview->productid);
		$sqlQuery->setNumber($clientproductreview->rating);
		$sqlQuery->setString2($clientproductreview->review);
		$sqlQuery->set($clientproductreview->sysDate);

		$sqlQuery->setNumber($clientproductreview->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM clientproductreview';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByClientid($value){
		$sql = 'SELECT * FROM clientproductreview WHERE clientid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProductid($value){
		$sql = 'SELECT * FROM clientproductreview WHERE productid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByRating($value){
		$sql = 'SELECT * FROM clientproductreview WHERE rating = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReview($value){
		$sql = 'SELECT * FROM clientproductreview WHERE review = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysDate($value){
		$sql = 'SELECT * FROM clientproductreview WHERE sysDate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByClientid($value){
		$sql = 'DELETE FROM clientproductreview WHERE clientid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProductid($value){
		$sql = 'DELETE FROM clientproductreview WHERE productid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByRating($value){
		$sql = 'DELETE FROM clientproductreview WHERE rating = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReview($value){
		$sql = 'DELETE FROM clientproductreview WHERE review = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysDate($value){
		$sql = 'DELETE FROM clientproductreview WHERE sysDate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return ClientproductreviewMySql 
	 */
	protected function readRow($row){
		$clientproductreview = new Clientproductreview();
		
		$clientproductreview->id = $row['id'];
		$clientproductreview->clientid = $row['clientid'];
		$clientproductreview->productid = $row['productid'];
		$clientproductreview->rating = $row['rating'];
		$clientproductreview->review = $row['review'];
		$clientproductreview->sysDate = $row['sysDate'];

		return $clientproductreview;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return ClientproductreviewMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>